%% SAMPLE_MEAS_TP_OS
% Plots the position and input voltage response found in the data_pos and
% data_vm variables. This script also find the associate peak time and
% percentage overshoot of the saved position step response.
%
%% Load sample data from MAT files
% Comment these lines out if you want to use the data recently stored in
% the data_pos and data_vm variables from after running q_srv02_pos.mdl.
% load('data_step_rsp_q3_theta.mat');
% load('data_step_rsp_q3_Im.mat');
%
%% Setup variables
% Load from variables set in workspace after running a Simulink model or
% from the previously saved response saved in the MAT files above.
t = data_pos(:,1);
yd = data_pos(:,2);
y = data_pos(:,3);
u = data_Im(:,2);
%
%% Plot response
% Initial time (s)
ti = 0;
% Final time (s)
tf = 5;
%
subplot(2,1,1);
plot(t,yd,'b:',t,y,'r-');
axis([ti tf -1 1]);
ylabel('\theta (rad)');
%
subplot(2,1,2);
plot(t,u,'r-');
axis([ti tf -2 2]);
xlabel('time (s)');
ylabel('I_m (A)');
%
%% Measure Specs
% Measure the peak time, settling time, steady-state error, and percentage
% overshoot of the response.
c_ts = 0.04;
% for simulation
% [ tp_m, ts_m, e_ss_m, PO_m ] = meas_step_rsp_specs( t, yd, y, c_ts, 0.001*2*pi/(4*1024));
% for implementation, set tolerance to sensor resolution (e.g. encoder).
[ tp_m, ts_m, e_ss_m, PO_m ] = meas_step_rsp_specs( t, yd, y, c_ts, 2*pi/(4*1024));
%
%% Display Results
disp(' ');
disp( 'Measured specifications: ' )
disp( [ '       tp = ' num2str( tp_m, 3 ) ' s' ] )
disp( [ '       ts = ' num2str( ts_m, 3 ) ' s' ] )
disp( [ '       PO = ' num2str( PO_m, 3 ) ' %' ] )
disp( [ '     e_ss = ' num2str( e_ss_m, 3 ) ' rad' ] )